function[tstep,trise,tfall,gain,NPE,Qshot,G,nadc,bw,tau,taus,T,R,fs,ts,apjit]=params();
tstep=500e-15;                         % Time steps(seconds)
%
% MCP params
% trise=200ps, tfall=2*trise, gain=1e5, Ishot=5nA, T=300K, NPE=50
trise=100e-12/tstep; tfall=0;           % Rise, fall times (time steps)
gain=1e5;                               % MCP gain
NPE=50;                                 % Photoelectrons  
% Shot noise= Qshot*gain*1.6e-19/(3*tau)=3uA I_dark max MCP Burle=3uA (.2PEs)
% Current shot noise to scale with Jerry's: 50 PE SN 80; 
%Qshot=.00022;                          % Shot noise (PE)
Qshot=.00009;
%
% Qshot=1e-20;                          % No shot noise; 
%
% Electronics params
G=1;                                    % Elec gain
nadc=16;                                % Digitization
bw=1.5e9;                                % Signal bandwidth  
tau=.35/(bw*tstep);                     % Signal time constant (time steps)
bws=20e9;                               % Shotnoise bandwidth
taus=.35/(bws*tstep);                   % Shotnoise time constant (time steps)
T=300;                                  % Temperature
% Noise in Ohms to scale with Jerry's: 50 PE SN 80; 
% R=50;
R=100;
%
% R=1e-20;                                                  % No white noise
% Elec noise resistance
%
% Sampling params
fs=100e9;                               % Sampling frequency
ts=(1/fs)/tstep;                        % Sampling period (time steps)
apjit=20e-12;
apjit=apjit/tstep;                      % Sampling jitter (time steps)
% No sampling jitter;   apjit=0e-12;
