function[mns,maxsignal]=sample(i,tstep,fy,tau,stat);
% Sample fy at ts rate (in number of samples)
% t0 in number of samples
% tstep=math time step;   
% tau=shaper time constant duration (number of samples)
% ts=sampling period (number of samples)
%
[tstep,trise,tfall,gain,NPE,Ishot,G,nadc,bw,tau,taus,T,R,fs,ts,apjit]=params();
%
nfy=size(fy,2);
%
% Sample instants
stimes=round([2*apjit+1:ts:nfy]+apjit*rand(1,size([2*apjit+1:ts:nfy],2))-apjit);
%
% min(stimes)
% max(stimes)
% size(fy,2)
% ADC quantization;
imax=2*NPE*gain*1.6e-19/((trise+tfall)*tstep);
% disp('ADC quantum');
q=imax*(1+3/sqrt(NPE))/2^nadc;
% max(stimes)
% size(fy) %return
mns=round(fy(i,stimes)/q)*q;
maxsignal=max(abs(mns));
sz=size(mns,2); scalex=(1:sz)*ts*tstep;
% figure(9); plot(scalex,mns); title('Sampled noisy measurement'); 
%
% Spectra
%
% ffy=fft(mns);
% scalefy=(1:size(mns,2)/2)*(1/(size(mns,2)*ts*tstep));
% figure(99);
% loglog(scalefy,abs(ffy(1:size(mns,2)/2)));

